package com.bytesbee.mysinglelivechannel.fcm;

import static com.bytesbee.mysinglelivechannel.utils.Constant.EXTRA_BACKGROUND;
import static com.bytesbee.mysinglelivechannel.utils.Constant.EXTRA_DATA;
import static com.bytesbee.mysinglelivechannel.utils.Constant.EXTRA_IMAGE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.EXTRA_MESSAGE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.EXTRA_TITLE;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.activities.MainActivity;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.utils.Utils;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import org.json.JSONObject;

import java.util.Date;

/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link <a href="https://bytesbee.com">BytesBee</a>
 */
public class MyFirebaseMessagingService extends FirebaseMessagingService {

    //private String fcm_url = Constant.TOKEN_URL;
    private NotificationUtils notificationUtils;
    private Intent resultIntent;
    private NotificationHelper notificationHelper;

    @Override
    public void onNewToken(@NonNull final String token) {
        super.onNewToken(token);
        if (notificationUtils == null) {
            notificationUtils = new NotificationUtils(getApplicationContext());
        }
        notificationUtils.sendRegistrationToServer(token);
    }

    @Override
    public void onMessageReceived(@NonNull RemoteMessage remoteMessage) {

        if (Utils.isEnabledMandatoryLogin()) {
            if (SessionManager.get().isNotLoggedIn()) {
                return;
            }
        }
        if (!SessionManager.get().isNotificationOn()) {
            return;
        }

        Utils.sout("onMessage Rec: " + remoteMessage.getMessageId());

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            notificationHelper = new NotificationHelper(this);
        }

        if (remoteMessage.getNotification() != null) {
            handlePushNotification(remoteMessage.getNotification().getTitle(), remoteMessage.getNotification().getBody());
        }

        if (!remoteMessage.getData().isEmpty()) {
            try {
                JSONObject json = new JSONObject(remoteMessage.getData().toString());
                handleDataMessage(json);
            } catch (Exception e) {
                Utils.getErrors(e);
            }
        }
    }

    private void handlePushNotification(String title, String message) {
        resultIntent = new Intent(getApplicationContext(), MainActivity.class);
        resultIntent.putExtra(EXTRA_MESSAGE, message);
        displayNotificationMessage(getApplicationContext(), title, message, resultIntent);
    }

    private void handleDataMessage(JSONObject json) {
        try {
            final JSONObject data = json.getJSONObject(EXTRA_DATA);
            final boolean isBackgroundNotification = data.has(EXTRA_BACKGROUND) && data.getBoolean(EXTRA_BACKGROUND);

            if (isBackgroundNotification) {

                Utils.requestSettingApi(getApplicationContext());

            } else {

                final String title = data.has(EXTRA_TITLE) ? data.getString(EXTRA_TITLE) : getString(R.string.app_name);
                final String message = data.has(EXTRA_MESSAGE) ? data.getString(EXTRA_MESSAGE) : "Simple message!";
                String imageUrl = data.has(EXTRA_IMAGE) ? data.getString(EXTRA_IMAGE) : "";
                String webUrl = "";

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    NotificationCompat.Builder notificationBuilder;
                    if (TextUtils.isEmpty(imageUrl)) {
                        notificationBuilder = notificationHelper.getNotificationBackground(title, message, webUrl);
                    } else {
                        imageUrl = Utils.getAPIUrl(getApplicationContext()) + imageUrl;
                        Bitmap bitmap = Utils.getBitmapFromURL(imageUrl);
                        if (bitmap != null) {
                            notificationBuilder = notificationHelper.getNotificationBackgroundWithImage(title, message, bitmap, webUrl);
                        } else {
                            notificationBuilder = notificationHelper.getNotificationBackground(title, message, webUrl);
                        }
                    }
                    if (notificationBuilder != null) {
                        notificationHelper.notify((int) new Date().getTime(), notificationBuilder);
                    }
                } else {
                    resultIntent = new Intent(getApplicationContext(), MainActivity.class);
                    resultIntent.putExtra(EXTRA_MESSAGE, message);
                    if (TextUtils.isEmpty(imageUrl) && (!imageUrl.endsWith(".jpg") || !imageUrl.endsWith(".png"))) {
                        displayNotificationMessage(getApplicationContext(), title, message, resultIntent);
                    } else {
                        imageUrl = Utils.getAPIUrl(getApplicationContext()) + imageUrl;
                        displayNotificationMessageWithBigImage(getApplicationContext(), title, message, resultIntent, imageUrl);
                    }
                }
            }

        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    private void displayNotificationMessage(Context context, String title, String message, Intent intent) {
        notificationUtils = new NotificationUtils(context);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        notificationUtils.showNotificationMessage(title, message, intent);
    }

    private void displayNotificationMessageWithBigImage(Context context, String title, String message, Intent intent, String imageUrl) {
        try {
            notificationUtils = new NotificationUtils(context);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
            notificationUtils.showNotificationMessage(title, message, intent, imageUrl);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }
}
